
#ifndef SST_TST_ATP_AUTHENTICATORS_H
#define SST_TST_ATP_AUTHENTICATORS_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:06:34 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_Authenticators.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
/*Authenticator test struct*/
typedef struct TST_ATP_PassAuthTestDataStruct{  
    char              TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_MasterPassword[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_MasterPasswordSizeInBytes;
    DxUint32_t                  TST_MasterMaxNumOfTrials;
    DxByte_t                    TST_SecondaryPassword[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_SecondaryPasswordSizeInBytes;
    DxUint32_t                  TST_SecondaryMaxNumOfTrials;
    DxByte_t                    TST_NewSecPassword[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_NewSecPasswordSizeInBytes;
    DxUint32_t                  TST_NewSecMaxNumOfTrials;
    DxByte_t                    TST_Data[TST_TEMP_DATA_LENGTH];
    DxUint32_t                  TST_DataSize;
} TST_ATP_PassAuthTestDataStruct;



typedef struct TST_ATP_RsaAuthTestDataStruct{  
    char              TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_N[TST_N_SIZE_BYTES];
    DxUint32_t                  TST_NSizeInBytes;
    DxByte_t                    TST_D[TST_N_SIZE_BYTES];
    DxUint32_t                  TST_DSizeInBytes;
    DxByte_t                    TST_E[TST_E_SIZE_BYTES];
    DxUint32_t                  TST_ESizeInBytes;
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize;  
    DxByte_t                    TST_NewChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_NewChallengeBuffSize;  
    DxByte_t                    TST_SignedChallengeBuff[TST_N_SIZE_BYTES];
    DxUint16_t                  TST_SignedChallengeBuffSize;
    DxByte_t                    TST_Data[TST_TEMP_DATA_LENGTH];
    DxUint32_t                  TST_DataSize;
} TST_ATP_RsaAuthTestDataStruct;

#if TST_USE_AUTHENTICATOR_MODULE
typedef struct TST_ATP_AesKeyAuthTestDataStruct{  
    char              TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_AesKey[TST_AES_KEY_SIZE];
    DxUint32_t                  TST_KeySizeInBytes;
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize;  
    DxByte_t                    TST_NewChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_NewChallengeBuffSize; 
    DxByte_t                    TST_EncChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_EncChallengeBuffSize;
    DxByte_t                    TST_Data[TST_TEMP_DATA_LENGTH];
    DxUint32_t                  TST_DataSize;
} TST_ATP_AesKeyAuthTestDataStruct;


typedef struct TST_ATP_ECCAuthTestDataStruct{  
    char              TST_Name[TST_NAME_STRING_LEN];
    DxUint8_t                   TST_ExternalPublKey[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPublKeySize;
    DxUint8_t                   TST_ExternalPrivKey[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPrivKeySize;
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize;  
    DxByte_t                    TST_NewChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_NewChallengeBuffSize;  
    DxByte_t                    TST_SignedChallengeBuff[TST_N_SIZE_BYTES];
    DxUint32_t                  TST_SignedChallengeBuffSize;
    DxByte_t                    TST_Data[TST_TEMP_DATA_LENGTH];
    DxUint32_t                  TST_DataSize;
} TST_ATP_ECCAuthTestDataStruct;

/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*****************************************************************************
* Function Name:                                                           
*  SST_TST_ATP_PasswordAuthenticator         
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
* Test the creation, deletion, modification, opening, 
* closing and usage of a password authenticator object. 
* And demonstrate the use of transaction with authenticator objects
*  
* Algorithm:       
*    1.  Create a new session by calling: SST_SessionCreate.
*    2.  Open a transaction by calling: SST_TransactionStart.
*    3.  Create a new master password authenticator by calling: SST_AuthenticatorPasswordCreate.
*    4.  Close the transaction by calling: SST_TransactionEnd
*    5.  Open the master password authentication by calling: SST_AuthenticationOpen.
*    6.  Open a transaction by calling: SST_TransactionStart.
*    7.  Create a new secondary password authenticator by calling: SST_AuthenticatorPasswordCreate.
*    8.  Close the transaction by calling: SST_TransactionEnd. 
*    9.  Open the secondary authenticator by calling: SST_AuthenticationOpen.
*    10.  Open a transaction by calling: SST_TransactionStart.
*    11.  Modify the password for the authenticator by calling: SST_AuthenticatorPasswordResetAndChange.
*    12.  Close the authenticator by calling: SST_AuthenticationClose.
*    13.  Close the transaction by calling: SST_TransactionEnd.
*    14.  Reopen the secondary authenticator using the new password by calling: SST_AuthenticationOpen.
*    15.  Close the authenticator by calling: SST_AuthenticationClose.
*    16.  Open the master authenticator using the new password by calling: SST_AuthenticationOpen.
*    17.  Open a transaction by calling: SST_TransactionStart.
*    18.  Insert a new data object by calling: SST_InsertData.
*    19.  Delete the data by calling: SST_DeleteData.
*    20.  Close the authenticator by calling: SST_AuthenticationClose.
*    21.  Delete the authenticators (one by one) by calling: SST_AuthenticatorDelete.
*    22.  Close the transaction by calling: SST_TransactionClose.
*    23.  Delete the session by calling: SST_SessionDelete.
*                                
*******************************************************************************/  
DxError_t SST_TST_ATP_PasswordAuthenticator ( void );
/*****************************************************************************
* Function Name:                                                           
*  SST_TST_ATP_RsaAsymAuthenticator         
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
* Test the creation, deletion, modification, opening, closing and usage of an asymmetric key authenticator object.
* And demonstration on the use of transaction with authenticator objects.
*  
* Algorithm:       
*    1.  Build a Private Key using CRYS for CRYS usage by calling: CRYS_RSA_Build_PrivKey (externally generated key).
*    2.  Create a new session by calling: SST_SessionCreate.
*    3.  Open a transaction by calling: SST_TransactionStart.
*    4.  Create a new asymmetric key authenticator by calling: SST_AuthenticatorPubKeyRSACreate.
*    5.  Close the transaction by calling: SST_TransactionClose.
*    6.  Open a transaction by calling: SST_TransactionStart.
*    7.  Open the new authenticator by calling: 
*        i.    SST_AuthenticatorChallengeGet 
*        ii.  CRYS_RSA_PSS_Sign
*        iii.  SST_AuthenticationOpen.
*    8.  Close the transaction by calling: SST_TransactionClose.
*    9.  Open a transaction by calling: SST_TransactionStart.
*    10.  Insert a new data object by calling: SST_InsertData.
*    11.  Close the authenticator by calling: SST_AuthenticationClose.
*    12.  Open the authenticator by calling: 
*        i.      SST_AuthenticatorChallengeGet 
*        ii.  CRYS_RSA_PSS_Sign
*        iii.  SST_AuthenticationOpen.
*    13.  Close the transaction by calling: SST_TransactionClose.
*    14.  Open a transaction by calling: SST_TransactionStart.
*    15.  Delete the data by calling: SST_DeleteData.
*    16.  Delete the authenticator by calling: SST_AuthenticatorDelete.
*    17.  Close the transaction by calling: SST_TransactionClose.
*    18.  Delete the session by calling: SST_SessionDelete.                           
*
*******************************************************************************/ 
DxError_t SST_TST_ATP_RsaAsymAuthenticator ( void );
/*****************************************************************************
* Function Name:                                                           
*  SST_TST_ATP_AesKeyAsymAuthenticator         
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
* Test the creation, deletion, modification, opening, closing and usage of a shared key authenticator object.
* And demonstration on the use of transaction with authenticator objects
*  
* Algorithm:       
*     1.  Create a new session by calling: SST_SessionCreate.
*     2.  Open a transaction by calling: SST_TransactionStart.
*     3.  Create a new asymmetric key authenticator by calling: SST_AuthenticatorAESSharedSecretCreate.
*     4.  Close the transaction by calling: SST_TransactionClose.
*     5.  Open a transaction by calling: SST_TransactionStart.
*     6.  Open the new authenticator by calling: 
*          i.      SST_AuthenticatorChallengeGet 
*          ii.      CRYS_AES (Encrypt the challenge using the AES key)
*          iii.  SST_AuthenticationOpen.
*     7.  Close the transaction by calling: SST_TransactionClose.
*     8.  Open a transaction by calling: SST_TransactionStart.
*     9.  Insert a new data object by calling: SST_InsertData.
*     10.  Close the authenticator by calling: SST_AuthenticationClose.
*     11.  Open the new authenticator by calling: 
*          i.      SST_AuthenticatorChallengeGet 
*          ii.      CRYS_AES (Encrypt the challenge using the AES key)
*          iii.  SST_AuthenticationOpen.
*     12.  Close the transaction by calling: SST_TransactionClose.
*     13.  Open a transaction by calling: SST_TransactionStart.
*     14.  Delete the data by calling: SST_DeleteData.
*     15.  Close the authenticator by calling: SST_AuthenticationClose.
*     16.  Delete the authenticator by calling: SST_AuthenticatorDelete.
*     17.  Close the transaction by calling: SST_TransactionClose.
*     18.  Delete the session by calling: SST_SessionDelete.
* 
*******************************************************************************/     
DxError_t SST_TST_ATP_AesKeyAsymAuthenticator  ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_ECCAsymAuthenticator         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the creation, deletion, modification, opening, closing and usage of an ECC asymmetric key authenticator object.
 * And demonstration on the use of transaction with authenticator objects.
 *  
 * Algorithm:       
 *    1.  Build a Private Key using CRYS for CRYS usage by calling: CRYS_RSA_Build_PrivKey (externally generated key).
 *    2.  Create a new session by calling: SST_SessionCreate.
 *    3.  Open a transaction by calling: SST_TransactionStart.
 *    4.  Create a new asymmetric key authenticator by calling: SST_AuthenticatorPubKeyECCCreate.
 *    5.  Close the transaction by calling: SST_TransactionClose.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Open the new authenticator by calling: 
 *        i.    SST_AuthenticatorChallengeGet 
 *        ii.  CRYS_ECDSA_Sign
 *        iii.  SST_AuthenticationOpen.
 *    8.  Close the transaction by calling: SST_TransactionClose.
 *    9.  Open a transaction by calling: SST_TransactionStart.
 *    10.  Insert a new data object by calling: SST_InsertData.
 *    11.  Close the authenticator by calling: SST_AuthenticationClose.
 *    12.  Open the authenticator by calling: 
 *        i.      SST_AuthenticatorChallengeGet 
 *        ii.  CRYS_ECDSA_Sign
 *        iii.  SST_AuthenticationOpen.
 *    13.  Close the transaction by calling: SST_TransactionClose.
 *    14.  Open a transaction by calling: SST_TransactionStart.
 *    15.  Delete the data by calling: SST_DeleteData.
 *    16.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    17.  Close the transaction by calling: SST_TransactionClose.
 *    18.  Delete the session by calling: SST_SessionDelete.                           
 *
 *******************************************************************************/   
 DxError_t SST_TST_ATP_ECCAsymAuthenticator ( void );


#ifdef __cplusplus
}
#endif

#endif

#endif

